function[c_r,f_r,new_geo,S,inc,figure_counter,c_r_H,f_r_H,...
    w_r_Man,A_r_Man,P_r_Man,R_r_Man,V_r_Man,Q_r_Man,H_r_Man,stage_r] =...
    get_mannings_data(Hi_slope,Lo_slope, units, figure_counter)
%This function gets c and f from the Manning's function.  Also, it computes
% and saves the slope at each stage from the Manning's calculation.

mannings_choice = 0;
inc=0; %% Initialize to zero for the while loop, if this step is first

while mannings_choice == 0
    disp(' ')
    disp(' ')
    disp('<<<<    Hydraulic Geometry Power Regression Data    >>>>')
    disp(' ')
    disp('This program uses the Mannings Equation to calculate at-a-station depth geometry power functions.')
    disp('1. I want to manually enter the values of ''c'' and ''f'' of the power function.')
    disp('2. I want to input cross sectional geometry, and I need this program to calculate ''c'' and ''f''.')
    disp(' ')
    mannings_choice = input('Please enter 1 or 2:  ');
    
    switch mannings_choice
        case 1
            disp(' ')
            c_r = 0; f_r = 0;

            while c_r <= 0 | f_r <= 0

                if units == 1

                    disp('** IMPORTANT **')
                    disp('Please ensure your calculations of ''c'' and ''f'' are in Metric units, as you previously incidated.')

                else

                    disp('** IMPORTANT **')
                    disp('Please ensure your calculations of ''c'' and ''f'' are in English units, as you previously incidated.')

                end

                c_r = input('Please enter the value of c (where R=cQ^f):  ');
                disp(' ')
                f_r = input('Please enter the value of f (where R=cQ^f):  ');

                if c_r <= 0 | f_r <= 0
                    disp(' ')
                    disp('Please enter positive values for c and f.')
                    disp(' ')
                end %of if
                
            end %of while
            
            %% The slope vector can be calculated now because the Mannings
            %% function will not run in this case.
            inc = 100;   % inc is the number of stages between high and low flow
            for i=1:inc
                S(i) = Lo_slope + ((Hi_slope-Lo_slope)/(inc-1))*(i-1);
            end        

            new_geo = 0;
            c_r_H = 0; f_r_H = 0; w_r_Man = 0; A_r_Man = 0; P_r_Man= 0; 
            R_r_Man = 0; V_r_Man = 0; Q_r_Man = 0; H_r_Man = 0; stage_r = 0;
            
        case 2
            disp(' ')
            
            %check units
            if units == 1
                disp('Please copy your cross-sectional geometry (in meters) into the folder in which this program runs.')
                disp(' ')
            else
                disp('Please copy your cross-sectional geometry (in feet) into the folder in which this program runs.')
                disp(' ')
            end
            xs_string = input('Please input the name of the text file, including the .txt extension:  ','s');
            disp(' ')
            xs_geo=load(xs_string);         
            
            %% Asks for the increment
            while inc <= 0
                
                %Check units
                if units == 1
                    inc = input('Please enter the power regression stage increment (in meters) for the Manning''s calcualtion:  ');
                else
                    inc = input('Please enter the power regression stage increment (in feet) for the Manning''s calculation:  ');                    
                end
                
                if inc <= 0
                    disp(' ')
                    disp('Please input a positive value.')
                end % if
            end % while
            
            disp(' ')
            n=0;
            while n <= 0
                n = input('Please input the value of the Mannings n:  ');
                if n <= 0
                    disp(' ')
                    disp('Please input a positive value.')
                end % if
            end % while
            
            %% Now we will zero out the values of xs_geo
            minimums = min(xs_geo);
            xmin = minimums(1,1);
            ymin = minimums(1,2);
            
            for i=1:length(xs_geo)
                new_geo(i,1) = xs_geo(i,1)-xmin;
                new_geo(i,2) = xs_geo(i,2)-ymin;
            end
            
            %% Save the X and Y values of the x-section for ease of reference
            Xxs = new_geo(:,1);
            Yxs = new_geo(:,2);
            
            %% Save the values of the new x and y maximums and minimums
            xmin_new = min(Xxs);
            ymin_new = min(Yxs);
            
            xmax_new = max(Xxs);
            ymax_new = max(Yxs);
            
            %% get the value of y_max_new based on the cutoff options
            [ymax_new,cutoff_choice] = Mannings_cutoff(units,figure_counter,new_geo);
            
            disp(' ')
            disp('** The program is computing the Manning''s Power Function **')
            disp(' ')
            
            ymax_new_test = max(Yxs(find(Yxs <= ymax_new)));
            
            %% Now the width at each depth increment must be found
            for i=1:floor(ymax_new/inc)
                [Xo, Yo] = mminvinterp(Xxs,Yxs,inc*i);               
                
                %% This if statement accounts for the assumption that if the banks
                %% do not match, the side is taken as straight
                
                if mod(length(Xo),2) ~= 0 && cutoff_choice ~= 2

                    if find(Yxs == ymax_new_test) <= (length(Xxs)/3)
                        Xo(end+1) = xmax_new;
                        Yo(end+1) = inc*i;
                    elseif find(Yxs == ymax_new_test) >= (length(Xxs)/3)
                        Xo = [0; Xo];
                        Yo = [inc*i; Yo];
                    end %inner if                  

                end %outer if
                
                
                if mod(length(Xo),2) ~= 0 && cutoff_choice == 2

                    if find(Yxs == ymax_new_test) <= (length(Xxs)/3)
                        Xo = [0; Xo];
                        Yo = [inc*i; Yo];
                    elseif find(Yxs == ymax_new_test) >= (length(Xxs)/3)
                        Xo(end+1) = xmax_new;
                        Yo(end+1) = inc*i;
                    end %inner if                  

                end %outer if
                
                figure(figure_counter)
                plot(new_geo(:,1),new_geo(:,2),'g',Xo,Yo,'ro')
                hold on
                legend('Cross Sectional Geometry','Stage Increments',0)
                title('Data for the calculation of the Manning''s Power Function')
                if units == 1
                    xlabel('X distance (m)')
                    ylabel('Y distance (m)')
                else
                    xlabel('X distance (ft)')
                    ylabel('Y distance (ft)')
                end
                
                %% This loop gets the width at each increment by summing the
                %% invidual differences in the Xo vector.
                w_r_Man(i)=0;
                for j=length(Xo):-2:2
                    w_r_Man(i) = Xo(j) - Xo(j-1) + w_r_Man(i);
                end
                
                %% This loop will get the area under each depth increment and find the
                %% hydrolic radius at each increment
                A_under_curve(i) = 0;
    
                P_r_Man(i) = 0;
        
                for j=2:2:length(Xo)
                    
                    xo_start = min(find(Xxs>Xo(j-1)));
                    xo_end   = max(find(Xxs<Xo(j)));
                    
                    x_temp(1) = Xo(j-1);
                    x_temp(2) = Xxs(xo_start);
                    y_temp(1) = Yo(j-1);
                    y_temp(2) = Yxs(xo_start);
                    
                    p = xo_end - xo_start + 2;
                    
                    x_temp(p) = Xxs(xo_end);
                    x_temp(p+1) = Xo(j);
                    
                    y_temp(p) = Yxs(xo_end);
                    y_temp(p+1) = Yo(j);
                    
                    m=3;
                    for k=(xo_start+1):1:(xo_end-1)
                        x_temp(m) = Xxs(k);
                        y_temp(m) = Yxs(k);
                        m=m+1;
                    end
                    
                    %% Calculating the areas for each segment of the increment
                    A_under_curve(i) = trapz(x_temp,y_temp) + A_under_curve(i);
                    
                    %% Calculating the perimeter, P, at each segment of the
                    %% increment
                    for k=1:(length(x_temp)-1)
                        P_r_Man(i) = sqrt((x_temp(k+1) - x_temp(k))^2 +...
                            (y_temp(k+1) - y_temp(k))^2) + P_r_Man(i);
                    end
                    
                    %% Must clear x and y temp so no old values remain for next j
                    %% iteration
                    clear x_temp y_temp
                    
                end %j loop
                
                %% Finally, the area of each section is the height increment multiplied
                %% by the width subtracted by the area under the curve
                A_r_Man(i) = w_r_Man(i)*inc*i - A_under_curve(i);         
                
                R_r_Man(i) = A_r_Man(i)/P_r_Man(i);
                
                H_r_Man(i) = A_r_Man(i)/w_r_Man(i);
                
                %% Must clear Xo and Yo so no old values remain for next i iteration
                clear Xo Yo
                
                %% Slope interpolation at each increment
                S(i) = Lo_slope + ((Hi_slope-Lo_slope)/(floor(ymax_new/inc)-1))*(i-1);
                
                %% Finally, all values are present to solve the Manning's Equation
                if units == 1   
                    k = 1.0; % for metric units
                else
                    k = 1.486;  % for english units
                end
                
                Q_r_Man(i) = (k/n)*R_r_Man(i)^(2/3)*S(i)^(1/2)*A_r_Man(i);
                V_r_Man(i) = Q_r_Man(i)/A_r_Man(i);
                
            end           
            
            %% Now, finally, the values of c and f can be obtained from the
            %% relationship R = cQ^f.  In order to do so, it must be broken down into
            %% the y = mx + b form using logorithmic relations.  Therefore,
            %% log10(R) = f*log(Q) + log(c)
            
            %get the values of c and f for the hydrolic radius
            R = log10(R_r_Man);
            Q = log10(Q_r_Man);   
            
            p1 = polyfit(Q,R,1);   
            
            f_r = p1(1);
            c_r = 10^(p1(2));
            
            disp(' ')
            fprintf('** The value of c is %0.4f,',c_r)
            fprintf('\n')
            fprintf('** The value of f is %0.4f,',f_r)
            disp('  where: R = cQ^f.')            
            
            %get the values of c and f for the hydrolic depth
            H = log10(H_r_Man);

            p2 = polyfit(Q,H,1);

            f_r_H = p2(1);
            c_r_H = 10^(p2(2));
            
            disp(' ')
            fprintf('** The value of c is %0.4f,',c_r_H)
            fprintf('\n')
            fprintf('** The value of f is %0.4f,',f_r_H)
            disp('  where: H = cQ^f.')
            
            %get the stages
            stage_r = inc*(1:floor(ymax_new/inc));
            
        otherwise
            disp('Please enter 1 or 2.')
            mannings_choice = 0;
    end % switch
end % while

figure_counter = figure_counter + 1;